library(BoolNet)
file <- ("model.sbml")
#Loads an SBML document that specifies a qualitative model using the sbml-qual extension package.
network <- loadSBML(file, symbolic=FALSE)

#Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous

# identifies asynchronous attractors

Asynchronous_att <- getAttractors(network,
                                  type = c("asynchronous"),
                                  method = c("random"),
                                  startStates = 10,
                                  randomChainLength = 10000,
                                  avoidSelfLoops = TRUE,
                                  geneProbabilities = NULL,
                                  maxAttractorLength = Inf,
                                  returnTable = TRUE)
plotAttractors(attractors, mode="table")

#Eliminates irrelevant variables from the inputs of the gene transition functions
#this is usful if the network perturbed randommly
simplifyNetwork(network, readableFunctions = FALSE)

#Perturb the state trajectories of a network and assesses the robustness by comparing the successor
#states or the attractors of a set of initial states and a set of perturbed copies of these initial states

perturbTrajectories(network,
                    measure = c("hamming"),
                    numSamples = 1000,
                    flipBits = 1,
                    updateType = c("asynchronous"))


# determine unique properties of biological networks by comparing them to 
#a set of randomly generated networks with similar structure
testNetworkProperties(network,
                      numRandomNets = 100,
                      testFunction = "testIndegree",
                      accumulation = c("kullback_leibler"),
                      sign.level = 0.05,
                      drawSignificanceLevel = TRUE,
                      klMinVal = 1e-05)